<?php
namespace ElementPack\Includes;


if (!defined('ABSPATH')) exit; // Exit if accessed directly
/**
 * Class WPML_ElementPack_Hover_Video
 */
class WPML_ElementPack_Hover_Video extends WPML_Module_With_Items {

	/**
	 * @return string
	 */
	public function get_items_field() {
		return 'hover_video_list';
	}

	/**
	 * @return array
	 */
	public function get_fields() {
		return array( 
			'hover_video_title',
			'remote_url' => ['url'],
		);
	}

	/**
	 * @param string $field
	 * @return string
	 */
	protected function get_title( $field ) {
		switch( $field ) {

			case 'hover_video_title':
				return esc_html__( 'Title', 'bdthemes-element-pack' );

			case 'remote_url':
				return esc_html__( 'Video Source URL', 'bdthemes-element-pack' );

			default:
				return '';
		}
	}

	/**
	 * @param string $field
	 * @return string
	 */
	protected function get_editor_type( $field ) {
		switch( $field ) {
			case 'hover_video_title':
                return 'LINE';

			case 'remote_url':
				return 'LINK';

			default:
				return '';
		}
	}

}
